<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1\Interaction;

use Twilio\Options;
use Twilio\Values;

abstract class InteractionChannelOptions {
    /**
     * @param array $routing The Interaction Channels's optional routing parameters
     * @return UpdateInteractionChannelOptions Options builder
     */
    public static function update(array $routing = Values::ARRAY_NONE): UpdateInteractionChannelOptions {
        return new UpdateInteractionChannelOptions($routing);
    }
}

class UpdateInteractionChannelOptions extends Options {
    /**
     * @param array $routing The Interaction Channels's optional routing parameters
     */
    public function __construct(array $routing = Values::ARRAY_NONE) {
        $this->options['routing'] = $routing;
    }

    /**
     * The Interaction Channel's routing parameters.  Optional, may contain `status` to set the agent's Reservation state to either `closed` or `wrapup`.  Default is `wrapup` if unspecified.
     *
     * @param array $routing The Interaction Channels's optional routing parameters
     * @return $this Fluent Builder
     */
    public function setRouting(array $routing): self {
        $this->options['routing'] = $routing;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.UpdateInteractionChannelOptions ' . $options . ']';
    }
}