﻿<?php

use App\Enums\UserType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;

class InsertOrUpdateUserRoleOtherInitInfo extends Migration
{
    /**
     * This method insert default configuration
     * Author: kaysar
     * Date: 22-Jan-2021
     *
     * @return void
     */
    public function up()
    {
        // DB::table('users')->insert([
        //     ['name' => 'admin User', 'username' => 'admin', 'password' => Hash::make('11111111'), 'email' => 'admin@example.com', 'email_verified_at' => Carbon::now(), 'is_sys_adm' => 1, 'status' => 1, 'user_type' => UserType::SystemUser],
        //     ['name' => 'normal User', 'username' => 'user', 'password' => Hash::make('11111111'), 'email' => 'user@example.com', 'email_verified_at' => Carbon::now(), 'is_sys_adm' => 0, 'status' => 1, 'user_type' => UserType::SystemUser],
        // ]);

        // DB::table('sec_roles')->insert([
        //     ['name' => 'Admin Role', 'is_default_user_role' => 0, 'status' => 1, 'created_by' => 1],
        //     ['name' => 'Default Role', 'is_default_user_role' => 1, 'status' => 1, 'created_by' => 1],
        //     ['name' => 'Operator', 'is_default_user_role' => 0, 'status' => 1, 'created_by' => 1]
        // ]);

        // DB::table('sec_user_roles')->insert([
        //     ['sec_user_id' => 1, 'sec_role_id' => 1, 'status' => 1, 'created_by' => 1],
        //     ['sec_user_id' => 2, 'sec_role_id' => 3, 'status' => 1, 'created_by' => 1]
        // ]);

        //resource
        DB::unprepared("INSERT INTO `sec_resources` (`id`, `name`, `display_name`, `sec_resource_id`, `sec_module_id`, `status`, `serial`, `level`, `method`, `icon`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Dashboard', 'Dashboard', NULL, 1, 1, 0, 1, '', 'fas fa-tachometer-alt', 1, NULL, NULL, NULL),
        (2, 'dashboard.blade.php', 'Main Dashboard', 1, 1, 1, 1, 2, 'home', NULL, 1, NULL, NULL, NULL),
        (3, 'User Management', 'User Management', NULL, 1, 1, 1, 1, '', 'fas fa-user-shield', 1, 1, NULL, '2021-10-11 11:22:17'),
        (4, 'user.blade.php', 'User Info', 3, 1, 1, 0, 2, 'user.info', NULL, 1, NULL, NULL, NULL),
        (5, 'role.blade.php', 'Role Info', 3, 1, 1, 1, 2, 'role', NULL, 1, NULL, NULL, NULL),
        (6, 'role_permission.blade.php', 'Role Permission', 3, 1, 1, 2, 2, 'role.permission', NULL, 1, NULL, NULL, NULL),
        (7, 'Top Menu Settings', 'Settings', NULL, 1, 1, 3, 1, '', 'fas fa-cogs', 1, 1, '2021-10-12 09:48:55', '2021-10-20 03:12:03'),
        (8, 'department.blade.php', 'Department', 7, 1, 1, 1, 2, 'department', NULL, 1, NULL, '2021-10-12 09:51:03', '2021-10-12 09:51:03'),
        (9, 'designation.blade.php', 'Designation', 7, 1, 1, 2, 2, 'designation', NULL, 1, NULL, '2021-10-13 10:59:45', '2021-10-13 10:59:45'),
        (10, 'company.blade.php', 'Company', 7, 1, 1, 3, 2, 'company', NULL, 1, NULL, '2021-10-18 09:29:57', '2021-10-18 09:29:57'),
        (11, 'business-hour.blade.php', 'Business Hour', 7, 1, 1, 3, 2, 'business.hour', NULL, 1, NULL, '2021-10-18 09:35:29', '2021-10-18 09:35:29'),
        (12, 'Top Menu Service', 'Service', NULL, 1, 1, 4, 1, '', 'fas fa-briefcase', 1, 1, '2021-10-18 09:39:17', '2021-10-20 03:12:17'),
        (13, 'category.blade.php', 'Category', 12, 1, 1, 1, 2, 'category', NULL, 1, NULL, '2021-10-18 11:30:39', '2021-10-18 11:30:39'),
        (14, 'service.blade.php', 'Add Service', 12, 1, 1, 2, 2, 'service', '', 1, 1, '2021-10-18 12:56:25', '2021-10-30 10:41:24'),
        (15, 'Top Menu Employee', 'Staff / Employee', NULL, 1, 1, 5, 1, '', 'fas fa-user-tie', 1, 1, '2021-10-20 03:10:40', '2021-10-20 03:12:29'),
        (16, 'employee.blade.php', 'Staff Manage', 15, 1, 1, 1, 2, 'employee', NULL, 1, NULL, '2021-10-20 03:13:39', '2021-10-20 03:13:39'),
        (17, 'business-holiday.blade.php', 'Business Holiday', 7, 1, 1, 4, 2, 'business.holiday', '', 1, 1, '2021-10-30 12:49:01', '2021-10-30 12:51:42'),
        (18, 'branch.blade.php', 'Branch', 7, 1, 1, 1, 2, 'branch', NULL, 1, NULL, '2021-10-31 11:41:05', '2021-10-31 11:41:05'),
        (19, 'Top Menu Service Booking', 'Service Booking', NULL, 1, 1, 6, 1, 'service.booking', 'far fa-calendar-alt', 1, 1, '2021-11-10 11:18:04', '2021-11-10 11:23:34'),
        (20, 'booking-calendar.blade.php', 'Booking Calendar', 19, 1, 1, 1, 2, 'booking.calendar', '', 1, 1, '2021-11-10 11:18:58', '2021-11-10 11:23:24'),
        (22, 'customer.blade.php', 'Add Customer', 23, 1, 1, 1, 2, 'customer', '', 1, 1, '2021-11-14 12:37:21', '2021-11-14 12:43:38'),
        (23, 'Top Menu Customer', 'Customer', NULL, 1, 1, 5, 1, 'top.customer', 'fas fa-hands-helping', 1, NULL, '2021-11-14 12:42:53', '2021-11-14 12:42:53'),
        (24, 'Top Menu Website', 'Website', NULL, 1, 1, 8, 1, 'website', 'fas fa-globe-africa', 1, NULL, '2021-12-12 12:57:30', '2021-12-12 12:57:30'),
        (25, 'appearance.blade.php', 'Appearance', 24, 1, 1, 1, 2, 'website.appearance', NULL, 1, NULL, '2021-12-12 13:01:26', '2021-12-12 13:01:26'),
        (26, 'about-us.blade.php', 'About Us', 24, 1, 1, 2, 2, 'website.aboutus', NULL, 1, NULL, '2021-12-18 08:18:52', '2021-12-18 08:18:52'),
        (27, 'client-testimonial.blade.php', 'Client Testimonial', 24, 1, 1, 3, 2, 'website.client.testimonial', NULL, 1, NULL, '2021-12-19 10:23:07', '2021-12-19 10:23:07'),
        (28, 'frequently-asked-question.blade.php', 'FAQ', 24, 1, 1, 4, 2, 'website.frequently.asked.question', '', 1, 1, '2021-12-21 13:31:47', '2021-12-21 13:53:33'),
        (29, 'google-map.blade.php', 'Google Map', 24, 1, 1, 5, 2, 'website.google.map', '', 1, 1, '2021-12-21 23:40:11', '2021-12-21 23:44:03'),
        (30, 'photo-gallery.blade.php', 'Photo Gallery', 24, 1, 1, 6, 2, 'website.photo.gallery', '', 1, 1, '2021-12-22 00:30:30', '2021-12-22 00:33:37'),
        (31, 'terms-and-condition.blade.php', 'Terms & Condition', 24, 1, 1, 6, 2, 'website.terms.and.condition', '', 1, 1, '2021-12-22 10:34:22', '2021-12-22 10:35:04'),
        (32, 'website.menu.blade.php', 'Website Menu', 24, 1, 1, 0, 2, 'website.menu', NULL, 1, NULL, '2021-12-23 09:40:46', '2021-12-23 09:40:46'),
        (33, 'Top Menu Payment', 'Payment', NULL, 1, 1, 7, 1, '', 'fas fa-dollar-sign', 1, NULL, '2021-12-24 02:43:20', '2021-12-24 02:43:20'),
        (34, 'payment-config.blade.php', 'Payment Setup', 33, 1, 1, 1, 2, 'payment.config', NULL, 1, NULL, '2021-12-24 02:49:55', '2021-12-24 02:49:55'),
        (36, 'service-booking-info.blade.php', 'Booking Info', 19, 1, 1, 2, 2, 'service.booking.info', NULL, 1, NULL, '2022-01-04 08:56:26', '2022-01-04 08:56:26'),
        (37, 'email.configuration.blade.php', 'Email Configuration', 24, 1, 1, 3, 2, 'email.configuration', '', 1, 1, '2022-01-08 12:20:44', '2022-01-08 12:21:31');");

        //hrm_departments
        DB::unprepared("INSERT INTO `hrm_departments` (`id`, `name`, `order`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Example Department', 1, 1, 1, '2021-10-12 11:11:32', '2022-01-22 08:27:23');");

        //hrm_designations
        DB::unprepared("INSERT INTO `hrm_designations` (`id`, `name`, `order`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Example Designation', 1, 1, 1, '2021-10-13 11:03:51', '2022-01-14 12:42:10');");

        //branch
        DB::unprepared("INSERT INTO `cmn_branches` (`id`, `name`, `phone`, `email`, `address`, `order`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Example Branch', '01111111111', 'demo@example.com', 'Example Address', 0, 1, 1, 1, '2021-10-27 11:18:33', '2022-01-14 12:50:10');");

        //employee
        DB::unprepared("INSERT INTO `sch_employees` (`id`, `full_name`, `image_url`, `employee_id`, `cmn_branch_id`, `email_address`, `country_code`, `contact_no`, `hrm_department_id`, `hrm_designation_id`, `user_id`, `gender`, `dob`, `specialist`, `present_address`, `permanent_address`, `note`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Demo Staff', 'uploadfiles/wdyGp9ndxy9J0J5kM0XYmKQReeP6q3GhRuiMM2Xv.jpg', '00001', 1, 'demo@example.com', NULL, '+8801111111111', 1, 1, NULL, 1, '2022-04-20', 'Example Specialist', NULL, NULL, NULL, 1, NULL, 1, NULL, '2022-01-23 13:26:16');");

        //user
        $defaultPassword = Hash::make('12345678');
        DB::unprepared("INSERT INTO `users` (`id`, `name`, `username`, `is_sys_adm`, `photo`, `sch_employee_id`, `status`, `email`, `email_verified_at`, `password`, `remember_token`, `created_at`, `updated_at`, `user_type`) VALUES
        (1, 'admin User', 'admin', 1, 'uploadfiles/gCmBjghX7Fir4liC67nsJwmnUGgAZZ49TZzAaf29.jpg', NULL, 1, 'admin@example.com', '2021-10-11 10:59:29', '" . $defaultPassword . "', '7F8JQIsKlgljDzzv1vd7hHSTjRrt3hRqwnOWQbAItXUrSfZ0YqwQUrslWU3y', NULL, '2022-01-24 12:27:27', 1),
        (29, 'Web User', 'webuser', 0, NULL, NULL, 1, 'webuser@example.com', '2022-01-07 12:54:59', '" . $defaultPassword . "', 'M3sSk1deGVOh7FqDEXqzpDjR16RDqZO3sA0C70zeskDVp6p3F17mUtsF2YSY', '2022-01-07 12:54:59', '2022-01-14 13:25:15', 2),
        (30, 'Staff Employee', 'staff', 0, NULL, 1, 1, 'staff@gmail.com', '2022-01-14 13:05:43', '" . $defaultPassword . "', NULL, '2022-01-14 13:05:43', '2022-01-14 13:05:43', 1);");

        //sec role
        DB::unprepared("INSERT INTO `sec_roles` (`id`, `name`, `is_default_user_role`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Admin Role', 0, 1, 1, NULL, NULL, NULL),
        (2, 'Default Role', 1, 1, 1, 1, NULL, '2022-01-01 13:08:09'),
        (3, 'Operator', 0, 1, 1, NULL, NULL, NULL),
        (4, 'Staff Role', 0, 1, 1, NULL, '2022-01-14 12:58:11', '2022-01-14 12:58:11');");

        //user role
        DB::unprepared("INSERT INTO `sec_user_roles` (`id`, `sec_user_id`, `sec_role_id`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 1, 1, 1, 1, NULL, NULL, '2022-01-24 12:27:27'),
        (12, 30, 4, 1, 1, NULL, '2022-01-14 13:05:43', '2022-01-14 13:05:43');");

        //sec role permission info
        DB::unprepared("INSERT INTO `sec_role_permission_infos` (`id`, `sec_resource_id`, `permission_name`, `route_name`, `status`, `created_by`, `created_at`, `updated_at`) VALUES
        (1, 2, 'Booking Status', 'dashboard.booking.status', 1, 1, NULL, '2021-12-25 03:34:40'),
        (2, 4, 'Add', 'add.new.user', 1, 1, NULL, NULL),
        (3, 4, 'Edit', 'edit.user.info', 1, 1, NULL, NULL),
        (4, 4, 'Delete', 'delete.user.info', 1, 1, NULL, NULL),
        (5, 5, 'Add', 'add.new.role', 1, 1, NULL, NULL),
        (6, 5, 'Edit', 'edit.role.info', 1, 1, NULL, NULL),
        (7, 5, 'Delete', 'delete.role.info', 1, 1, NULL, NULL),
        (8, 6, 'Save Permission', 'save.or.update.permission', 1, 1, NULL, NULL),
        (9, 6, 'Edit Menu Name', 'update.resource.display.name', 1, 1, NULL, NULL),
        (10, 8, 'Update', 'department.update', 1, 1, '2021-10-12 09:51:58', '2021-10-12 09:52:25'),
        (11, 8, 'Add', 'department.add', 1, 1, '2021-10-12 09:53:02', '2021-10-12 09:53:02'),
        (12, 8, 'Delete', 'department.delete', 1, 1, '2021-10-12 09:53:18', '2021-10-12 09:53:18'),
        (13, 9, 'Add', 'designation.store', 1, 1, '2021-10-13 11:01:56', '2021-10-13 11:01:56'),
        (14, 9, 'Update', 'designation.update', 1, 1, '2021-10-13 11:03:21', '2021-10-13 11:03:21'),
        (15, 9, 'Delete', 'designation.delete', 1, 1, '2021-10-13 11:03:37', '2021-10-13 11:03:37'),
        (16, 10, 'Add', 'company.add', 1, 1, '2021-10-18 09:32:18', '2021-10-18 09:32:18'),
        (17, 10, 'Update', 'company.update', 1, 1, '2021-10-18 09:32:49', '2021-10-18 09:32:49'),
        (18, 11, 'Add', 'business.hour.add', 1, 1, '2021-10-18 09:35:59', '2021-10-18 09:35:59'),
        (19, 11, 'Update', 'business.hour.update', 1, 1, '2021-10-18 09:36:30', '2021-10-18 09:36:30'),
        (20, 14, 'Add', 'service.add', 1, 1, '2021-10-18 12:57:28', '2021-10-30 10:47:35'),
        (21, 14, 'Update', 'service.update', 1, 1, '2021-10-18 12:57:46', '2021-10-30 10:47:54'),
        (22, 14, 'Delete', 'service.delete', 1, 1, '2021-10-18 12:58:00', '2021-10-30 10:48:07'),
        (23, 16, 'Add', 'employee.add', 1, 1, '2021-10-20 03:13:59', '2021-10-20 03:13:59'),
        (24, 16, 'Update', 'employee.update', 1, 1, '2021-10-20 03:14:13', '2021-10-20 03:14:13'),
        (25, 16, 'Save Change Off Day', 'save.update.offday', 1, 1, '2021-10-29 11:21:35', '2021-10-29 11:21:35'),
        (26, 16, 'Delete Off day', 'delete.employee.offday', 1, 1, '2021-10-29 23:58:05', '2021-10-29 23:58:05'),
        (27, 16, 'Move Off day', 'update.offday.by.move', 1, 1, '2021-10-30 01:09:56', '2021-10-30 01:09:56'),
        (28, 18, 'Add', 'branch.add', 1, 1, '2021-10-31 11:42:22', '2021-10-31 11:42:22'),
        (29, 18, 'Update', 'branch.update', 1, 1, '2021-10-31 11:42:36', '2021-10-31 11:42:36'),
        (30, 18, 'Delete', 'branch.delete', 1, 1, '2021-10-31 11:43:05', '2021-10-31 11:43:05'),
        (31, 17, 'Save Change', 'save.update.business.holiday', 1, 1, '2021-10-31 11:43:37', '2021-10-31 11:43:37'),
        (32, 17, 'Move', 'update.business.holiday.by.move', 1, 1, '2021-10-31 11:44:11', '2021-10-31 11:44:11'),
        (33, 17, 'Delete', 'delete.business.holiday', 1, 1, '2021-10-31 11:44:27', '2021-10-31 11:44:27'),
        (34, 20, 'Save Booking', 'save.service.booking', 1, 1, '2021-12-07 10:06:46', '2021-12-07 10:06:46'),
        (35, 20, 'Update Booking', 'update.service.booking', 1, 1, '2021-12-11 11:14:10', '2021-12-11 11:14:10'),
        (36, 20, 'Cancel Booking', 'cancel.service.booking', 1, 1, '2021-12-12 12:53:43', '2021-12-27 08:49:08'),
        (37, 20, 'Delete Booking', 'delete.service.booking', 1, 1, '2021-12-12 12:54:02', '2021-12-12 12:54:02'),
        (38, 25, 'Save Change', 'save.or.update.appearance', 1, 1, '2021-12-18 08:17:31', '2021-12-18 08:17:31'),
        (39, 27, 'Save', 'website.save.client.testimonial', 1, 1, '2021-12-21 13:28:52', '2021-12-21 13:28:52'),
        (40, 27, 'Update', 'website.update.client.testimonial', 1, 1, '2021-12-21 13:29:08', '2021-12-21 13:29:08'),
        (41, 27, 'Delete', 'website.delete.client.testimonial', 1, 1, '2021-12-21 13:29:22', '2021-12-21 13:29:22'),
        (42, 26, 'Save', 'website.save.aboutus', 1, 1, '2021-12-21 13:29:37', '2021-12-21 13:29:37'),
        (43, 26, 'Update', 'website.update.aboutus', 1, 1, '2021-12-21 13:29:55', '2021-12-21 13:29:55'),
        (44, 26, 'Delete', 'website.delete.aboutus', 1, 1, '2021-12-21 13:30:09', '2021-12-21 13:30:09'),
        (45, 28, 'Save', 'website.save.frequently.asked.question', 1, 1, '2021-12-21 13:54:32', '2021-12-21 13:54:32'),
        (46, 28, 'Update', 'website.update.frequently.asked.question', 1, 1, '2021-12-21 13:54:44', '2021-12-21 13:54:44'),
        (47, 28, 'Delete', 'website.delete.frequently.asked.Question', 1, 1, '2021-12-21 13:55:05', '2021-12-21 13:55:05'),
        (48, 29, 'Save Change', 'website.save.or.update.google.map', 1, 1, '2021-12-21 23:40:48', '2021-12-21 23:40:48'),
        (49, 30, 'Save', 'website.save.photo.gallery', 1, 1, '2021-12-22 00:30:49', '2021-12-22 00:30:49'),
        (50, 30, 'Update', 'website.update.photo.gallery', 1, 1, '2021-12-22 00:31:08', '2021-12-22 00:31:08'),
        (51, 30, 'Delete', 'website.delete.photo.gallery', 1, 1, '2021-12-22 00:31:20', '2021-12-22 00:31:20'),
        (52, 31, 'Save Change', 'website.save.or.update.terms.condition', 1, 1, '2021-12-22 12:49:07', '2021-12-22 12:49:07'),
        (53, 32, 'Save', 'website.save.menu', 1, 1, '2021-12-24 08:52:04', '2021-12-24 08:52:04'),
        (54, 32, 'Update', 'website.update.menu', 1, 1, '2021-12-24 08:52:23', '2021-12-24 08:52:23'),
        (55, 32, 'Delete', 'website.delete.menu', 1, 1, '2021-12-24 08:52:40', '2021-12-24 08:52:40'),
        (56, 34, 'Save Change Currency', 'save.or.update.currency', 1, 1, '2021-12-24 13:14:02', '2022-01-23 13:50:46'),
        (57, 34, 'Enable Local Payment', 'currency.update', 1, 1, '2021-12-24 13:14:19', '2022-01-23 13:50:19'),
        (58, 34, 'Enable Paypal Payment', 'enable.or.disable.paypa.payment', 1, 1, '2021-12-24 13:14:38', '2022-01-23 13:49:48'),
        (59, 34, 'Save Paypal API', 'save.or.update.paypal.config', 1, 1, '2021-12-24 13:15:23', '2022-01-23 13:49:25'),
        (60, 20, 'Done Booking', 'done.service.booking', 1, 1, '2021-12-27 08:49:29', '2021-12-27 08:49:29'),
        (63, 22, 'Save', 'customer.store', 1, 1, '2022-01-04 08:57:54', '2022-01-04 08:57:54'),
        (64, 22, 'Update', 'customer.update', 1, 1, '2022-01-04 08:58:14', '2022-01-04 08:58:14'),
        (65, 22, 'Delete', 'customer.delete', 1, 1, '2022-01-04 08:58:31', '2022-01-04 08:58:31'),
        (66, 37, 'Save Change', 'save.email.configuration', 1, 1, '2022-01-10 13:25:56', '2022-01-10 13:25:56'),
        (67, 36, 'Change Service Status', 'change.service.booking.status', 1, 1, '2022-01-10 13:27:32', '2022-01-10 13:27:32'),
        (68, 13, 'Add', 'category.add', 1, 1, '2022-01-14 12:31:24', '2022-01-14 12:31:24'),
        (69, 13, 'Update', 'category.update', 1, 1, '2022-01-14 12:31:38', '2022-01-14 12:31:38'),
        (70, 13, 'Delete', 'category.delete', 1, 1, '2022-01-14 12:31:53', '2022-01-14 12:31:53');");

        //sec role permission
        DB::unprepared("INSERT INTO `sec_role_permissions` (`id`, `sec_role_permission_info_id`, `sec_role_id`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 1, 1, 1, 1, NULL, NULL, NULL),
        (2, 2, 1, 1, 1, NULL, NULL, NULL),
        (3, 3, 1, 1, 1, NULL, NULL, NULL),
        (4, 4, 1, 1, 1, NULL, NULL, NULL),
        (5, 5, 1, 1, 1, NULL, NULL, NULL),
        (6, 6, 1, 1, 1, NULL, NULL, NULL),
        (7, 7, 1, 1, 1, NULL, NULL, NULL),
        (8, 8, 1, 1, 1, 1, NULL, '2021-10-11 11:27:44'),
        (9, 9, 1, 1, 1, NULL, NULL, NULL),
        (10, 1, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (11, 2, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (12, 3, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (13, 4, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (14, 5, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (15, 6, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (16, 7, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (17, 8, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (18, 9, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (19, 1, 2, 1, 1, NULL, NULL, NULL),
        (20, 2, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (21, 3, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (22, 4, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (23, 5, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (24, 6, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (25, 7, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (26, 8, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (27, 9, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (28, 10, 1, 1, 1, NULL, '2021-10-12 09:53:39', NULL),
        (29, 11, 1, 1, 1, NULL, '2021-10-12 09:53:39', NULL),
        (30, 12, 1, 1, 1, NULL, '2021-10-12 09:53:39', NULL),
        (31, 13, 1, 1, 1, 1, '2021-10-18 10:04:23', '2021-10-18 10:04:28'),
        (32, 14, 1, 1, 1, 1, '2021-10-18 10:04:23', '2021-10-18 10:04:28'),
        (33, 15, 1, 1, 1, 1, '2021-10-18 10:04:23', '2021-10-18 10:04:28'),
        (34, 16, 1, 1, 1, NULL, '2021-10-18 10:04:23', NULL),
        (35, 17, 1, 1, 1, NULL, '2021-10-18 10:04:23', NULL),
        (36, 18, 1, 1, 1, NULL, '2021-10-18 10:04:23', NULL),
        (37, 19, 1, 1, 1, NULL, '2021-10-18 10:04:23', NULL),
        (38, 20, 1, 1, 1, 1, '2021-10-20 03:17:07', '2021-10-30 10:42:00'),
        (39, 21, 1, 1, 1, 1, '2021-10-20 03:17:07', '2021-10-30 10:42:00'),
        (40, 22, 1, 1, 1, 1, '2021-10-20 03:17:07', '2021-10-30 10:42:00'),
        (41, 23, 1, 1, 1, NULL, '2021-10-20 03:17:07', NULL),
        (42, 24, 1, 1, 1, NULL, '2021-10-20 03:17:07', NULL),
        (43, 25, 1, 1, 1, 1, '2021-10-30 10:42:00', '2021-12-12 12:58:01'),
        (44, 26, 1, 1, 1, 1, '2021-10-30 10:42:00', '2021-12-12 12:58:01'),
        (45, 27, 1, 1, 1, 1, '2021-10-30 10:42:00', '2021-12-12 12:58:01'),
        (46, 28, 1, 1, 1, NULL, '2021-10-31 11:44:48', NULL),
        (47, 29, 1, 1, 1, NULL, '2021-10-31 11:44:48', NULL),
        (48, 30, 1, 1, 1, NULL, '2021-10-31 11:44:48', NULL),
        (49, 31, 1, 1, 1, 1, '2021-10-31 11:44:48', '2021-12-12 12:58:01'),
        (50, 32, 1, 1, 1, 1, '2021-10-31 11:44:48', '2021-12-12 12:58:01'),
        (51, 33, 1, 1, 1, 1, '2021-10-31 11:44:48', '2021-12-12 12:58:01'),
        (52, 34, 1, 1, 1, NULL, '2021-12-07 10:07:06', NULL),
        (53, 35, 1, 1, 1, NULL, '2021-12-11 11:14:24', NULL),
        (54, 36, 1, 1, 1, NULL, '2021-12-12 12:58:01', NULL),
        (55, 37, 1, 1, 1, NULL, '2021-12-12 12:58:01', NULL),
        (56, 38, 1, 1, 1, NULL, '2021-12-18 08:19:11', NULL),
        (57, 42, 1, 1, 1, 1, '2021-12-21 13:53:53', '2021-12-21 23:41:05'),
        (58, 43, 1, 1, 1, 1, '2021-12-21 13:53:53', '2021-12-21 23:41:05'),
        (59, 44, 1, 1, 1, 1, '2021-12-21 13:53:53', '2021-12-21 23:41:05'),
        (60, 39, 1, 1, 1, 1, '2021-12-21 13:53:53', '2021-12-21 23:41:05'),
        (61, 40, 1, 1, 1, 1, '2021-12-21 13:53:53', '2021-12-21 23:41:05'),
        (62, 41, 1, 1, 1, 1, '2021-12-21 13:53:53', '2021-12-21 23:41:05'),
        (63, 45, 1, 1, 1, NULL, '2021-12-21 23:41:05', NULL),
        (64, 46, 1, 1, 1, NULL, '2021-12-21 23:41:05', NULL),
        (65, 47, 1, 1, 1, NULL, '2021-12-21 23:41:05', NULL),
        (66, 48, 1, 1, 1, NULL, '2021-12-21 23:41:05', NULL),
        (67, 49, 1, 1, 1, NULL, '2021-12-22 00:31:33', NULL),
        (68, 50, 1, 1, 1, NULL, '2021-12-22 00:31:33', NULL),
        (69, 51, 1, 1, 1, NULL, '2021-12-22 00:31:33', NULL),
        (70, 52, 1, 1, 1, 1, '2021-12-23 09:41:02', '2021-12-24 02:43:49'),
        (71, 53, 1, 1, 1, 1, '2021-12-24 08:52:54', '2021-12-24 13:15:43'),
        (72, 54, 1, 1, 1, 1, '2021-12-24 08:52:54', '2021-12-24 13:15:43'),
        (73, 55, 1, 1, 1, 1, '2021-12-24 08:52:54', '2021-12-24 13:15:44'),
        (74, 56, 1, 1, 1, NULL, '2021-12-24 13:15:43', NULL),
        (75, 57, 1, 1, 1, NULL, '2021-12-24 13:15:43', NULL),
        (76, 58, 1, 1, 1, NULL, '2021-12-24 13:15:43', NULL),
        (77, 59, 1, 1, 1, NULL, '2021-12-24 13:15:43', NULL),
        (78, 10, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (79, 11, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (80, 12, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (81, 28, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (82, 29, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (83, 30, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (84, 13, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (85, 14, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (86, 15, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (87, 16, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (88, 17, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (89, 18, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (90, 19, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (91, 31, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (92, 32, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (93, 33, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (94, 20, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (95, 21, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (96, 22, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (97, 23, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (98, 24, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (99, 25, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (100, 26, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (101, 27, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (102, 34, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (103, 35, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (104, 36, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (105, 37, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (106, 56, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (107, 57, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (108, 58, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (109, 59, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (110, 53, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (111, 54, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (112, 55, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (113, 38, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (114, 42, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (115, 43, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (116, 44, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (117, 39, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (118, 40, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (119, 41, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (120, 45, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (121, 46, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (122, 47, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (123, 48, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (124, 49, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (125, 50, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (126, 51, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (127, 52, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (128, 60, 1, 1, 1, NULL, '2022-01-01 13:08:33', NULL),
        (131, 63, 1, 1, 1, 1, '2022-01-04 09:44:41', '2022-01-10 13:27:45'),
        (132, 64, 1, 1, 1, 1, '2022-01-04 09:44:41', '2022-01-10 13:27:45'),
        (133, 65, 1, 1, 1, 1, '2022-01-04 09:44:41', '2022-01-10 13:27:45'),
        (134, 66, 1, 1, 1, NULL, '2022-01-10 13:26:22', NULL),
        (135, 67, 1, 1, 1, NULL, '2022-01-10 13:27:45', NULL),
        (136, 68, 1, 1, 1, NULL, '2022-01-14 12:32:41', NULL),
        (137, 69, 1, 1, 1, NULL, '2022-01-14 12:32:41', NULL),
        (138, 70, 1, 1, 1, NULL, '2022-01-14 12:32:41', NULL),
        (139, 10, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:27'),
        (140, 11, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:27'),
        (141, 12, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:27'),
        (142, 28, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:27'),
        (143, 29, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:27'),
        (144, 30, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:27'),
        (145, 13, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:27'),
        (146, 14, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:27'),
        (147, 15, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:28'),
        (148, 16, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:28'),
        (149, 17, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:28'),
        (150, 18, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:28'),
        (151, 19, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:28'),
        (152, 31, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:28'),
        (153, 32, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:28'),
        (154, 33, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:52:28'),
        (155, 68, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (156, 69, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (157, 70, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (158, 20, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (159, 21, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (160, 22, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (161, 23, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (162, 24, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (163, 25, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (164, 26, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (165, 27, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (166, 63, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (167, 64, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (168, 65, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (169, 34, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (170, 35, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (171, 36, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (172, 37, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (173, 60, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (174, 67, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (175, 56, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (176, 57, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (177, 58, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (178, 59, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (179, 53, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (180, 54, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (181, 55, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (182, 38, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (183, 42, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (184, 43, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (185, 44, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (186, 39, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (187, 40, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (188, 41, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (189, 66, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (190, 45, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (191, 46, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (192, 47, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (193, 48, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (194, 49, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (195, 50, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (196, 51, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (197, 52, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (198, 68, 2, 0, 1, NULL, '2022-01-14 12:56:16', NULL),
        (199, 69, 2, 0, 1, NULL, '2022-01-14 12:56:16', NULL),
        (200, 70, 2, 0, 1, NULL, '2022-01-14 12:56:16', NULL),
        (201, 63, 2, 0, 1, NULL, '2022-01-14 12:56:16', NULL),
        (202, 64, 2, 0, 1, NULL, '2022-01-14 12:56:16', NULL),
        (203, 65, 2, 0, 1, NULL, '2022-01-14 12:56:16', NULL),
        (204, 60, 2, 0, 1, NULL, '2022-01-14 12:56:16', NULL),
        (205, 67, 2, 0, 1, NULL, '2022-01-14 12:56:16', NULL),
        (206, 66, 2, 1, 1, NULL, '2022-01-14 12:56:17', NULL),
        (207, 1, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (208, 2, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (209, 3, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (210, 4, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (211, 5, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (212, 6, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (213, 7, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (214, 8, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (215, 9, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (216, 10, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (217, 11, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (218, 12, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (219, 28, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (220, 29, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (221, 30, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (222, 13, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (223, 14, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (224, 15, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (225, 16, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (226, 17, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (227, 18, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (228, 19, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (229, 31, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (230, 32, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (231, 33, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (232, 68, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (233, 69, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (234, 70, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (235, 20, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (236, 21, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (237, 22, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (238, 23, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (239, 24, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (240, 25, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (241, 26, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (242, 27, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (243, 63, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (244, 64, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (245, 65, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (246, 34, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (247, 35, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (248, 36, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (249, 37, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (250, 60, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (251, 67, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (252, 56, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (253, 57, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (254, 58, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (255, 59, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (256, 53, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (257, 54, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (258, 55, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (259, 38, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (260, 42, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (261, 43, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (262, 44, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (263, 39, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (264, 40, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (265, 41, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (266, 66, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (267, 45, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (268, 46, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (269, 47, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (270, 48, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (271, 49, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (272, 50, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (273, 51, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL),
        (274, 52, 4, 0, 1, NULL, '2022-01-14 12:58:41', NULL);");

        //sec resource permission
        DB::unprepared("INSERT INTO `sec_resource_permissions` (`id`, `display_name`, `sec_resource_id`, `sec_role_id`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Dashboard', 1, 1, 1, 1, NULL, NULL, NULL),
        (2, 'Main Dashboard', 2, 1, 1, 1, NULL, NULL, '2021-12-25 01:21:20'),
        (3, 'User Management', 3, 1, 1, 1, NULL, NULL, NULL),
        (4, 'User Info', 4, 1, 1, 1, NULL, NULL, NULL),
        (5, 'Role Info', 5, 1, 1, 1, NULL, NULL, NULL),
        (6, 'Role Permission', 6, 1, 1, 1, NULL, NULL, NULL),
        (7, 'Dashboard', 1, 3, 1, 1, 1, NULL, '2022-01-14 12:52:00'),
        (8, 'User Dashboard', 2, 3, 1, 1, 1, NULL, '2022-01-14 12:52:00'),
        (9, 'User Management', 3, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (10, 'User Info', 4, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (11, 'Role Info', 5, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (12, 'Role Permission', 6, 3, 0, 1, 1, NULL, '2022-01-14 12:57:37'),
        (13, 'Dashboard', 1, 2, 1, 1, NULL, NULL, NULL),
        (14, 'Main Dashboard', 2, 2, 1, 1, NULL, NULL, '2021-12-25 01:18:34'),
        (15, 'User Management', 3, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (16, 'User Info', 4, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (17, 'Role Info', 5, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (18, 'Role Permission', 6, 2, 0, 1, 1, NULL, '2022-01-14 12:56:16'),
        (19, 'Settings', 7, 1, 1, 1, NULL, '2021-10-12 09:49:38', NULL),
        (20, 'Department', 8, 1, 1, 1, NULL, '2021-10-12 09:53:39', NULL),
        (21, 'Designation', 9, 1, 1, 1, NULL, '2021-10-13 11:00:07', NULL),
        (22, 'Company', 10, 1, 1, 1, NULL, '2021-10-18 10:04:23', NULL),
        (23, 'Business Hour', 11, 1, 1, 1, NULL, '2021-10-18 10:04:23', NULL),
        (24, 'Service', 12, 1, 1, 1, NULL, '2021-10-18 10:04:23', NULL),
        (25, 'Category', 13, 1, 1, 1, NULL, '2021-10-20 03:17:07', NULL),
        (26, 'Service', 14, 1, 1, 1, 1, '2021-10-20 03:17:07', '2021-10-30 10:42:00'),
        (27, 'Staff / Employee', 15, 1, 1, 1, NULL, '2021-10-20 03:17:07', NULL),
        (28, 'Staff Manage', 16, 1, 1, 1, NULL, '2021-10-20 03:17:07', NULL),
        (29, 'Business Holiday', 17, 1, 1, 1, NULL, '2021-10-30 12:52:02', NULL),
        (30, 'Branch', 18, 1, 1, 1, NULL, '2021-10-31 11:44:48', NULL),
        (31, 'Service Booking', 19, 1, 1, 1, NULL, '2021-11-10 11:20:42', NULL),
        (32, 'Booking Calendar', 20, 1, 1, 1, NULL, '2021-11-10 11:20:42', NULL),
        (33, 'Customer', 23, 1, 1, 1, NULL, '2021-11-14 12:43:50', NULL),
        (34, 'Add Customer', 22, 1, 1, 1, NULL, '2021-11-14 12:43:50', NULL),
        (35, 'Website', 24, 1, 1, 1, NULL, '2021-12-12 12:58:01', NULL),
        (36, 'Appearance', 25, 1, 1, 1, NULL, '2021-12-12 13:05:19', NULL),
        (37, 'About Us', 26, 1, 1, 1, NULL, '2021-12-18 08:19:11', NULL),
        (38, 'Client Testimonial', 27, 1, 1, 1, NULL, '2021-12-19 10:23:30', NULL),
        (39, 'FAQ', 28, 1, 1, 1, NULL, '2021-12-21 13:53:53', NULL),
        (40, 'Google Map', 29, 1, 1, 1, NULL, '2021-12-21 23:41:05', NULL),
        (41, 'Photo Gallery', 30, 1, 1, 1, NULL, '2021-12-22 00:31:33', NULL),
        (42, 'Terms & Condition', 31, 1, 1, 1, NULL, '2021-12-22 10:35:42', NULL),
        (43, 'Website Menu', 32, 1, 1, 1, NULL, '2021-12-23 09:41:02', NULL),
        (44, 'Payment', 33, 1, 1, 1, NULL, '2021-12-24 02:43:49', NULL),
        (45, 'Payment Setup', 34, 1, 1, 1, NULL, '2021-12-24 08:52:54', NULL),
        (46, 'Settings', 7, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (47, 'Department', 8, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (48, 'Branch', 18, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (49, 'Designation', 9, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (50, 'Company', 10, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (51, 'Business Hour', 11, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (52, 'Business Holiday', 17, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (53, 'Service', 12, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (54, 'Category', 13, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (55, 'Add Service', 14, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (56, 'Staff / Employee', 15, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (57, 'Staff Manage', 16, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (58, 'Customer', 23, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (59, 'Add Customer', 22, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (60, 'Service Booking', 19, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (61, 'Booking Calendar', 20, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (62, 'Payment', 33, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (63, 'Payment Setup', 34, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (64, 'Website', 24, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (65, 'Website Menu', 32, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (66, 'Appearance', 25, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (67, 'About Us', 26, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (68, 'Client Testimonial', 27, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (69, 'FAQ', 28, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (70, 'Google Map', 29, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (71, 'Photo Gallery', 30, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (72, 'Terms & Condition', 31, 2, 1, 1, NULL, '2021-12-25 01:11:41', NULL),
        (74, 'Booking Info', 36, 1, 1, 1, NULL, '2022-01-04 09:44:41', NULL),
        (75, 'Email Configuration', 37, 1, 1, 1, NULL, '2022-01-08 12:22:14', NULL),
        (76, 'Settings', 7, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (77, 'Department', 8, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (78, 'Branch', 18, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (79, 'Designation', 9, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (80, 'Company', 10, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (81, 'Business Hour', 11, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (82, 'Business Holiday', 17, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (83, 'Service', 12, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (84, 'Category', 13, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (85, 'Add Service', 14, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (86, 'Staff / Employee', 15, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (87, 'Staff Manage', 16, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (88, 'Customer', 23, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (89, 'Add Customer', 22, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (90, 'Service Booking', 19, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (91, 'Booking Calendar', 20, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (92, 'Booking Info', 36, 3, 1, 1, NULL, '2022-01-14 12:51:34', NULL),
        (93, 'Payment', 33, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (94, 'Payment Setup', 34, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (95, 'Website', 24, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (96, 'Website Menu', 32, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (97, 'Appearance', 25, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (98, 'About Us', 26, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (99, 'Client Testimonial', 27, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (100, 'Email Configuration', 37, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (101, 'FAQ', 28, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (102, 'Google Map', 29, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (103, 'Photo Gallery', 30, 3, 1, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:56:43'),
        (104, 'Terms & Condition', 31, 3, 0, 1, 1, '2022-01-14 12:51:34', '2022-01-14 12:57:37'),
        (105, 'Booking Info', 36, 2, 1, 1, NULL, '2022-01-14 12:56:16', NULL),
        (106, 'Email Configuration', 37, 2, 1, 1, NULL, '2022-01-14 12:56:16', NULL),
        (107, 'Dashboard', 1, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (108, 'Main Dashboard', 2, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (109, 'User Management', 3, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (110, 'User Info', 4, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (111, 'Role Info', 5, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (112, 'Role Permission', 6, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (113, 'Settings', 7, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (114, 'Department', 8, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (115, 'Branch', 18, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (116, 'Designation', 9, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (117, 'Company', 10, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (118, 'Business Hour', 11, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (119, 'Business Holiday', 17, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (120, 'Service', 12, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (121, 'Category', 13, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (122, 'Add Service', 14, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (123, 'Staff / Employee', 15, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (124, 'Staff Manage', 16, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (125, 'Customer', 23, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (126, 'Add Customer', 22, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (127, 'Service Booking', 19, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (128, 'Booking Calendar', 20, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (129, 'Booking Info', 36, 4, 1, 1, NULL, '2022-01-14 12:58:41', NULL),
        (130, 'Payment', 33, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (131, 'Payment Setup', 34, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (132, 'Website', 24, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (133, 'Website Menu', 32, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (134, 'Appearance', 25, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (135, 'About Us', 26, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (136, 'Client Testimonial', 27, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (137, 'Email Configuration', 37, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (138, 'FAQ', 28, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (139, 'Google Map', 29, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (140, 'Photo Gallery', 30, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16'),
        (141, 'Terms & Condition', 31, 4, 0, 1, 1, '2022-01-14 12:58:41', '2022-01-14 13:10:16');");


        //service category
        DB::unprepared("INSERT INTO `sch_service_categories` (`id`, `name`, `created_by`, `modified_by`, `created_at`, `updated_at`) VALUES
        (1, 'Example Category', NULL, NULL, '2021-10-26 08:38:20', '2022-01-14 12:32:45');");

        //sch_services
        DB::unprepared("INSERT INTO `sch_services` (`id`, `title`, `image`, `sch_service_category_id`, `visibility`, `price`, `duration_in_days`, `duration_in_time`, `time_slot_in_time`, `padding_time_before`, `padding_time_after`, `appoinntment_limit_type`, `appoinntment_limit`, `minimum_time_required_to_booking_in_days`, `minimum_time_required_to_booking_in_time`, `minimum_time_required_to_cancel_in_days`, `minimum_time_required_to_cancel_in_time`, `remarks`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Example Service', 'uploadfiles/E7cBlCZzl8sMnyTOxTPec3folCZezKZYwAEImc1J.jpg', 1, 1, '100.00', 0, '00:30:00', '00:30:00', '00:05:00', '00:01:00', 2, 10, 0, '00:00:00', 0, '01:10:00', 'Example service description.', NULL, NULL, '2021-10-31 12:19:17', '2022-01-23 13:25:52');");

        //cmn_business_holidays
        DB::unprepared("INSERT INTO `cmn_business_holidays` (`id`, `cmn_branch_id`, `title`, `start_date`, `end_date`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
       (4, 1, 'rewewr', '2021-10-11', '2021-10-12', 1, 1, '2021-10-31 11:38:09', '2021-10-31 11:40:03'),
       (5, 1, 'rewr', '2021-10-19', '2021-10-20', 1, NULL, '2021-10-31 11:39:57', '2021-10-31 11:39:57'),
       (11, 1, 'test', '2021-12-21', '2021-12-21', 1, NULL, '2021-12-17 08:46:01', '2021-12-17 08:46:01');");

        //cmn_business_hours
        DB::unprepared("INSERT INTO `cmn_business_hours` (`id`, `day`, `start_time`, `end_time`, `is_off_day`, `cmn_branch_id`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (36, '0', '07:00:00', '23:55:00', 1, 1, 1, NULL, NULL, '2022-01-14 12:39:17'),
        (37, '1', '07:00:00', '23:45:00', 0, 1, 1, NULL, NULL, '2022-01-14 12:39:17'),
        (38, '2', '07:00:00', '23:55:00', 0, 1, 1, NULL, NULL, '2022-01-14 12:39:17'),
        (39, '3', '07:00:00', '23:55:00', 0, 1, 1, NULL, NULL, '2022-01-14 12:39:17'),
        (40, '4', '07:00:00', '23:45:00', 0, 1, 1, NULL, NULL, '2022-01-14 12:39:17'),
        (41, '5', '07:00:00', '23:55:00', 0, 1, 1, NULL, NULL, '2022-01-14 12:39:17'),
        (42, '6', '07:00:00', '23:45:00', 0, 1, 1, NULL, NULL, '2022-01-14 12:39:17');");

        //cmn_companies
        DB::unprepared("INSERT INTO `cmn_companies` (`id`, `name`, `address`, `phone`, `mobile`, `email`, `web_address`, `image_link`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (9, 'Example Company', 'Example Company Address', '01111111111', '01111111111', 'demo@example.com', 'www.example.com', NULL, 1, 1, '2021-10-18 10:17:27', '2022-01-14 12:41:36');");

        //cmn_currency_setups
        DB::unprepared("INSERT INTO `cmn_currency_setups` (`id`, `name`, `value`, `created_at`, `updated_at`) VALUES
        (1, '$', 'USD', '2021-10-31 18:00:00', '2021-12-24 13:13:22');");

        //cmn_customers
        DB::unprepared("INSERT INTO `cmn_customers` (`id`, `user_id`, `full_name`, `phone_no`, `email`, `dob`, `country`, `state`, `postal_code`, `city`, `street_address`, `street_number`, `remarks`, `created_at`, `updated_at`) VALUES
        (1, 29, 'Web User', '448801111111', 'webuser@example.com', NULL, NULL, NULL, NULL, NULL, 'Example customer address', NULL, NULL, '2021-11-19 00:11:07', '2022-01-22 10:33:17'),
        (39, NULL, 'example customer', '8806732625222', 'demo@example.com', NULL, NULL, 'Dhaka', '1230', 'Inside Dhaka Metro City', 'Demo address', NULL, NULL, '2022-01-22 04:22:32', '2022-01-22 04:22:32'),
        (40, NULL, 'example customer 2', '8801672886562', 'demo1@gmail.com', NULL, NULL, 'Dhaka', '1230', 'Inside Dhaka Metro City', 'demo address', NULL, NULL, '2022-01-22 07:47:48', '2022-01-22 07:47:48');");


        //cmn_paypal_api_configs
        DB::unprepared("INSERT INTO `cmn_paypal_api_configs` (`id`, `cmn_payment_type_id`, `client_id`, `client_secret`, `sandbox`, `charge_type`, `charge_percentage`, `created_at`, `updated_at`) VALUES
        (1, 2, 'test_id', 'test_key', 1, 1, '0.00', NULL, '2022-01-23 13:56:53');");


        //sch_employee_schedules
        DB::unprepared("INSERT INTO `sch_employee_schedules` (`id`, `sch_employee_id`, `day`, `start_time`, `end_time`, `break_start_time`, `break_end_time`, `is_off_day`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (15, 1, 0, '07:00:00', '23:55:00', '01:50:00', '02:10:00', 0, 1, 1, '2021-12-20 13:40:25', '2021-12-20 13:41:15'),
        (16, 1, 1, '07:00:00', '23:45:00', '01:50:00', '01:50:00', 0, 1, 1, '2021-12-20 13:40:25', '2021-12-20 13:41:15'),
        (17, 1, 2, '07:00:00', '23:55:00', '01:50:00', '01:50:00', 0, 1, 1, '2021-12-20 13:40:25', '2021-12-20 13:41:15'),
        (18, 1, 3, '07:00:00', '23:55:00', '01:50:00', '01:50:00', 0, 1, 1, '2021-12-20 13:40:25', '2021-12-20 13:41:15'),
        (19, 1, 4, '07:00:00', '23:45:00', '01:50:00', '01:50:00', 0, 1, 1, '2021-12-20 13:40:25', '2021-12-20 13:41:15'),
        (20, 1, 5, '07:00:00', '23:55:00', '01:50:00', '01:50:00', 1, 1, 1, '2021-12-20 13:40:25', '2021-12-20 13:41:15'),
        (21, 1, 6, '07:00:00', '23:45:00', '01:50:00', '01:50:00', 0, 1, 1, '2021-12-20 13:40:25', '2021-12-20 13:41:15');");

        //sch_employee_services 
        DB::unprepared("INSERT INTO `sch_employee_services` (`id`, `sch_employee_id`, `sch_service_id`, `fees`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 1, 1, '43.00', 1, 1, 1, '2021-11-02 09:18:22', '2022-01-23 13:26:16');");

        //user branch
        DB::unprepared("INSERT INTO `sec_user_branches` (`id`, `user_id`, `cmn_branch_id`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (46, 30, 1, 1, NULL, NULL, NULL);");

        //about us
        DB::unprepared("INSERT INTO `site_about_us` (`id`, `title`, `details`, `image_url`, `status`, `order`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Example About  Title.', 'Example about details.', 'uploadfiles/NkEgaStAhCw3Cn4e674Axd9iHUcq5kYYDW3u7bHV.jpg', 1, 0, NULL, 1, NULL, '2022-01-23 13:36:52');");

        //site_appearances
        DB::unprepared("INSERT INTO `site_appearances` (`id`, `app_name`, `logo`, `icon`, `motto`, `theam_color`, `theam_hover_color`, `theam_active_color`, `facebook_link`, `youtube_link`, `twitter_link`, `instagram_link`, `about_service`, `contact_email`, `contact_phone`, `contact_web`, `background_image`, `meta_title`, `meta_description`, `meta_keywords`, `created_by`, `updated_by`, `created_at`, `updated_at`, `address`, `login_background_image`, `theam_menu_color2`) VALUES
        (1, 'Demo Booking', 'uploadfiles/Q0nUSMb5m849o33jV6jEfprgoIy4fHwjekv5CpEz.png', 'uploadfiles/zA6rybWqCD6x9pZBkYPleYReCmKNKDplR8LSe1o9.ico', 'Demo Website Motto', '#007bff', '#0b66c8', '#499df6', '#', '#', '#', '#', 'Example about service.', 'demo@example.com', '+67 0112 11111', 'www.example.com', 'uploadfiles/xBXh5meQhHnilJkEeENqCWrJCmt4rbPV0ftRI44L.jpg', 'Example meta', 'Example meta description', 'Example', NULL, 1, NULL, '2022-01-23 13:31:57', 'Example address', 'uploadfiles/aBRExUHaD2RcAiphZ42Si46BaUyZXpJkYMnFSBnr.jpg', '#ffffff');");
        
        //site_client_testimonials
        DB::unprepared("INSERT INTO `site_client_testimonials` (`id`, `name`, `description`, `rating`, `image`, `contact_phone`, `contact_email`, `client_ref`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Example Client Name', 'Example Feedback.', 3, 'uploadfiles/A67OhPaVjkOxeg10pIT9eG5k4WTUtI5IhMUlskAl.jpg', NULL, NULL, NULL, 1, NULL, 1, NULL, '2022-01-23 13:37:38');");
        
        //site_frequently_asked_questions
        DB::unprepared("INSERT INTO `site_frequently_asked_questions` (`id`, `question`, `answer`, `image_url`, `status`, `order`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, 'Example FAQ?', 'Example FAQ', 'uploadfiles/11P8vVjF38bsGYXxR74AGjkEFCO7ClQ2CvIj0mgs.jpg', 1, 1, NULL, 1, NULL, '2022-01-23 13:37:11');");
       
       //site_google_maps
       DB::unprepared("INSERT INTO `site_google_maps` (`id`, `lat`, `long`, `map_key`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
       (2, '24.877255', '90.386725', 'AIzaSyDwRZb6VdsCVE5gFMtR3X6Dik1Tx9bxhq0', 1, 1, '2021-12-21 23:50:08', '2022-01-23 13:39:35');");

        //site_menus
        DB::unprepared("INSERT INTO `site_menus` (`id`, `name`, `site_menu_id`, `order`, `route`, `remarks`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
            (1, 'Service', 0, 1, 'site.menu.services', '', 1, NULL, NULL, NULL, NULL),
            (2, 'Our Team', 0, 2, 'site.menu.team', '', 1, NULL, NULL, NULL, NULL),
            (3, 'Home', 0, 0, 'site.home', '', 1, NULL, NULL, NULL, NULL),
            (4, 'About Us', 0, 5, 'site.about.us', '', 1, NULL, NULL, NULL, NULL),
            (5, 'Contact Us', 0, 6, 'site.contact', '', 1, NULL, NULL, NULL, NULL),
            (7, 'Photo Gallery', 0, 3, 'site.photo.gallery', NULL, 1, NULL, 1, NULL, '2021-12-24 00:35:29'),
            (8, 'FAQ', 0, 4, 'site.faq', NULL, 1, NULL, 1, NULL, '2021-12-24 00:35:17');");

        //site_photo_galleries
        DB::unprepared("INSERT INTO `site_photo_galleries` (`id`, `name`, `image_url`, `order`, `status`, `description`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (2, 'Example Name', 'uploadfiles/fQLn6wrjdOzDq3SVHNdpN9XciNQIPDW9tMSF2Utg.jpg', 0, 1, NULL, NULL, 1, NULL, '2022-01-23 13:37:56');");
      
        //site_terms_and_conditions
        DB::unprepared("INSERT INTO `site_terms_and_conditions` (`id`, `details`, `status`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
        (1, '<p>Example terms &amp; conditions</p>', 1, NULL, 1, NULL, '2022-01-14 00:40:03');");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
